#ifndef USBPKTDEFS_H
#define USBPKTDEFS_H

typedef union 
{
    byte _byte[BOOT_EP_SIZE];  //For Byte Access
    struct
    {
        enum
        {
            READ_VERSION        = 0x00,
            READ_FLASH          = 0x01,
            WRITE_FLASH         = 0x02,
            ERASE_FLASH         = 0x03,
            READ_EEDATA         = 0x04,
            WRITE_EEDATA        = 0x05,
            READ_CONFIG         = 0x06,
            WRITE_CONFIG        = 0x07,
            UPDATE_LED          = 0x32,
			WINPIC_GETOKBUTTON 		= 0x50,
			WINPIC_GETDATAINBIT 	= 0x51,
			WINPIC_SETLEDS			= 0x52,
			WINPIC_SETVPP			= 0x53,
			WINPIC_SETVDD			= 0x54,
			WINPIC_SETCLOCKANDDATA	= 0x55,
			WINPIC_SETCLOCKENABLE	= 0x56,
			WINPIC_SETDATAENABLE	= 0x57,
			WINPIC_PULLMCLRTOGND	= 0x58,
			WINPIC_CONNECTTARGET	= 0x59,
			USB_CLOCK_SET_TIME      = 0x70,
			USB_CLOCK_GET_POWER    = 0x71,
			USB_CLOCK_GET_VOLTAGE  = 0x72,
			USB_CLOCK_SET_MODE      = 0x73,
			USB_CLOCK_GET_INFO      = 0x74,
			USB_CLOCK_SET_LV_TRIP   = 0x75,
			USB_CLOCK_SET_PWM       = 0x76,
			USB_CLOCK_SET_TIMEOUT   = 0x77,
			RESET                   = 0xFF
        }CMD;
        byte len;
        union
        {
            rom far char *pAdr;             //Address Pointer
            struct
            {
                byte low;                   //Little-indian order
                byte high;
                byte upper;
            };
        }ADR;
        byte data[DATA_SIZE];
    };

	// for UPDATE_LED COMMAND
    struct
    {
        unsigned :8;
        byte led_num;
        byte led_status;
    };

	// for WINPIC_GETOKBUTTON COMMAND
	struct
	{
		unsigned :8;
		byte ok_button;
	};

	// for WINPIC_DATAINBIT COMMAND
	struct
	{
		unsigned :8;
		byte	data_in_bit;
	};

	// for WINPIC_SETLEDS COMMAND
	struct
	{
		unsigned :8;
		byte led_bank;
	};

	// for WINPIC_SETVPP COMMAND
	struct
	{
		unsigned :8;
		int 	vpp_level;
		float	vpp_voltage;
	};

	// for WINPIC_SETVDD COMMAND

	struct
	{
		unsigned :8;
		int		vdd_level;
		float	vdd_voltage;
	};

	// for WINPIC_SETCLOCKANDDATA COMMAND

	struct
	{
		unsigned :8;
		byte	pgc;
		byte	pgd;
	};

	// for WINPIC_SETCLOCKENABLE COMMAND

	struct
	{
		unsigned :8;
		byte	clockenable;
	};

	// for WINPIC_SETDATAENABLE COMMAND

	struct
	{
		unsigned :8;
		byte	dataenable;
	};

	// for WINPIC_PULLMCLRTOGND COMMAND

	struct
	{
		unsigned :8;
		byte 	mclr;
	};

	// for WINPIC_CONNECTTARGET COMMAND

	struct
	{
		unsigned :8;
		byte	connection;
	};


	// for USB_CLOCK_SET

	struct
	{
		unsigned :8;
		byte 	hours;
		byte	minutes;
		byte 	seconds;
		byte	day;
		byte	month;
		int		year;
	};

} BOOT_DATA_PACKET;

#endif
